% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcSim.R
\name{dmcSim}
\alias{dmcSim}
\title{dmcSim: Run dmc simulation}
\usage{
dmcSim(
  amp = 20,
  tau = 30,
  drc = 0.5,
  bnds = 75,
  resDist = 1,
  resMean = 300,
  resSD = 30,
  aaShape = 2,
  spShape = 3,
  sigm = 4,
  nTrl = 1e+05,
  tmax = 1000,
  spDist = 0,
  spLim = c(-75, 75),
  spBias = 0,
  drDist = 0,
  drShape = 3,
  drLim = c(0.1, 0.7),
  rtMax = 5000,
  fullData = FALSE,
  nTrlData = 5,
  nDelta = 9,
  pDelta = vector(),
  tDelta = 1,
  nCAF = 5,
  printInputArgs = TRUE,
  printResults = TRUE,
  setSeed = FALSE,
  seedValue = 1
)
}
\arguments{
\item{amp}{amplitude of automatic activation}

\item{tau}{time to peak automatic activation}

\item{drc}{drift rate of controlled processes}

\item{bnds}{+- response criterion}

\item{resDist}{residual distribution type (1=normal, 2=uniform)}

\item{resMean}{residual distribution mean}

\item{resSD}{residual distribution standard deviation}

\item{aaShape}{shape parameter of automatic activation}

\item{spShape}{starting point (sp) shape parameter}

\item{sigm}{diffusion constant}

\item{nTrl}{number of trials}

\item{tmax}{number of time points per trial}

\item{spDist}{starting point (sp) distribution (0 = constant, 1 = beta, 2 = uniform)}

\item{spLim}{starting point (sp) range}

\item{spBias}{starting point (sp) bias}

\item{drDist}{drift rate (dr) distribution type (0 = constant, 1 = beta, 2 = uniform)}

\item{drShape}{drift rate (dr) shape parameter}

\item{drLim}{drift rate (dr) range}

\item{rtMax}{limit on simulated RT (decision + non-decisional component)}

\item{fullData}{TRUE/FALSE (Default: FALSE) NB. only required when plotting activation
function and/or individual trials}

\item{nTrlData}{Number of trials to plot}

\item{nDelta}{number of delta bins}

\item{pDelta}{alternative to nDelta by directly specifying required percentile values (0-100)}

\item{tDelta}{type of delta calculation (1=direct percentiles points, 2=percentile bounds (tile) averaging)}

\item{nCAF}{Number of CAF bins}

\item{printInputArgs}{TRUE/FALSE}

\item{printResults}{TRUE/FALSE}

\item{setSeed}{TRUE/FALSE If true, set seed to seed value}

\item{seedValue}{1}
}
\value{
dmcsim

The function returns a list with the relevant results from the simulation. The list
is accessed with obj$name with the the following:
\item{obj$means}{Condition means for reaction time and error rate}
\item{obj$caf}{Accuracy per bin for compatible and incompatible trials}
\item{obj$delta}{Mean RT and compatibility effect per bin}
\item{obj$sim}{Individual trial data points (reaction times/error) and activation vectors from simulation}
\item{obj$trials}{Example individual trial timecourse for n compatible and incompatible trials}
\item{obj$prms}{The input parameters used in the simulation}
}
\description{
DMC model simulation detailed in  Ulrich, R., Schroeter, H., Leuthold, H., & Birngruber, T. (2015).
Automatic and controlled stimulus processing in conflict tasks: Superimposed diffusion processes and delta functions.
Cognitive Psychology, 78, 148-174. This function is essentially a wrapper around the c++ function runDMC
}
\examples{
\donttest{
# Example 1
dmc <- dmcSim(fullData = TRUE)  # fullData only required for activation/trials (top/bottom left)
plot(dmc)
dmc <- dmcSim() # faster!
plot(dmc)

# Example 2
dmc <- dmcSim(tau = 130)
plot(dmc)

# Example 3
dmc <- dmcSim(tau = 90)
plot(dmc)

# Example 4
dmc <- dmcSim(spDist = 1)
plot(dmc, "delta")

# Example 5
dmc <- dmcSim(tau = 130, drDist = 1)
plot(dmc, "caf")

# Example 6
dmc <- dmcSim(nDelta = 10, nCAF = 10)
plot(dmc)
}

}
