% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dmclist}
\alias{plot.dmclist}
\title{plot.dmclist: Plot delta plots from multiple dmc simulations.}
\usage{
\method{plot}{dmclist}(
  x,
  ylim = NULL,
  xlim = NULL,
  figType = "delta",
  xlab = "Time [ms]",
  col = c("black", "lightgrey"),
  lineType = "l",
  legend = TRUE,
  legendPos = "topleft",
  legendLabels = NULL,
  ncol = 1,
  ...
)
}
\arguments{
\item{x}{Output from dmcSims}

\item{ylim}{ylimit for delta plot}

\item{xlim}{xlimit for delta plot}

\item{figType}{delta (default), deltaErrors}

\item{xlab}{x-label}

\item{col}{# color range start/end color}

\item{lineType}{line type ("l", "b", "o") for delta plot}

\item{legend}{TRUE/FALSE Show legend}

\item{legendPos}{legend position}

\item{legendLabels}{Custom legend labels}

\item{ncol}{number of legend columns}

\item{...}{pars for legend}
}
\description{
Plot delta function from multiple dmc simulations (i.e., dmcSims).
}
\examples{
\donttest{
# Example 1
params <- list(amp = seq(20, 30, 2))
dmc <- dmcSims(params)
plot(dmc, ncol = 2, col = c("red", "green"), legendPos = "topright")

# Example 2
params <- list(amp=c(10, 20), tau = seq(20, 80, 40), drc = seq(0.2, 0.6, 0.2), nTrl = 50000)
dmc <- dmcSims(params)
plot(dmc, ncol = 2, col=c("green", "blue"), ylim = c(-10, 120))

}

}
