% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatModels.R
\name{mapXy.gr.linear}
\alias{mapXy.gr.linear}
\title{Linear Map Function Gradient}
\usage{
mapXy.gr.linear(X, coeff)
}
\arguments{
\item{X}{Matrix of data.}

\item{coeff}{Vector or matrix of coefficients or weights.}
}
\value{
Matrix of values of the gradient of the linear map function with
respect to each value of coeff.
}
\description{
This function implements the gradient of the linear map function with respect
to coeff used for linear SVM and linear regression in the form required by
\code{\link{EmpiricalRiskMinimizationDP.CMS}} and
\code{\link{EmpiricalRiskMinimizationDP.KST}}.
}
\examples{
  X <- matrix(c(1,2,3,4,5,6),nrow=2)
  coeff <- c(0.5,-1,2)
  mapXy.gr.linear(X,coeff)

}
\keyword{internal}
