% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_filet.R
\name{read_filet}
\alias{read_filet}
\title{Reads time series data from a single DSSAT file T}
\usage{
read_filet(file_name, col_types = NULL, col_names = NULL,
  na_strings = NULL)
}
\arguments{
\item{file_name}{a character vector of length one that contains the name
of a single DSSAT output file}

\item{col_types}{One of NULL, a cols() specification, or a string.
See \code{\link[readr]{read_fwf}} or \code{vignette("readr")} for
more details.}

\item{col_names}{A character vector of column names; primarily
helpful for cases where there are no white spaces between column
names within the header line}

\item{na_strings}{a character vector of string to represent missing values}
}
\value{
a tibble containing the data from the raw DSSAT file
}
\description{
Reads time series data from a single DSSAT file T
}
\examples{

# Extract FileT path for sample file
sample_filet <- system.file('extdata','SAMPLE.CRT',package='DSSAT')

read_filet(sample_filet)

}
