% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{DE-class}
\alias{DE-class}
\title{An S4 class for simulating dose-titration study designs}
\description{
An S4 class for simulating dose-titration study designs
}
\section{Slots}{

\describe{
\item{\code{doses}}{A numeric vector of prospectively-determined discrete doses to
trial.}

\item{\code{units}}{A string indicating dose units, e.g. \code{"mg/kg"}.}

\item{\code{MTDi}}{A numeric vector of optimal doses for simulated study
participants. Optionally a call to an \code{r<distribution>(...)} function which
may be parsed to calculate the \code{mtd_quantiles} slot.}

\item{\code{mtd_quantiles}}{A numeric vector of quantiles of the distribution from
which the MTDi slot was simulated. Intended mainly to support visualization
of this distribution, e.g. as an transparent overlay on the dose-survival
plot. NULL in case \code{MTDi} is provided verbatim.}

\item{\code{fractol}}{A numeric vector of probabilities for the simulated MTDi slot.
Intended mainly to support visualization, e.g. plotting of 'MTD pointers'
on the interactive dose-survival plot.}

\item{\code{data}}{A data.frame with columns:
\itemize{
\item \code{id} Participant identifier
\item \code{period} DLT assessment period, numbered consecutively from 1
\item \code{dose} Dose level, numbered consecutively starting from 1
\item \code{dlt} A logical indicator: did this this participant experience
a DLT during this period?
}}

\item{\code{stop_esc}}{integer Period in which `stop rule' was triggered}

\item{\code{ds_conf_level}}{numeric Confidence level for confidence band around
Kaplan-Meier estimate of the dose-survival curve.}

\item{\code{dose_drop_threshold}}{numeric Threshold for triggering the `bypass rule'.}

\item{\code{stop_esc_under}}{numeric Threshold for triggering the `stop rule'.}

\item{\code{undo_esc_under}}{numeric Threshold for triggering the `rollback rule'.}
}}

