% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generate.R
\docType{data}
\name{data}
\alias{data}
\alias{twoStageCont}
\alias{twoStageCens}
\alias{twoStageSurv}
\title{Toy Two-Stage Trial Datasets}
\format{
twoStageCont is a dataset generated to mimic a simple two-stage
  trial. The data.frame contains 1000 observations with 5 columns: 
\describe{
\item{X1}{The first stage covariate. A normally distributed continuous variable.}
\item{A1}{The first stage treatment. A binary variable.}
\item{X2}{The second stage covariate. A normally distributed continuous variable.}
\item{A2}{The second stage treatment. A binary variable.}
\item{Y}{The outcome. A continuous variable.}
}

twoStageCens is a dataset generated to mimic a simple two-stage
  trial with right-censoring. The data.frame contains 1000 observations 
  with 9 columns: 
\describe{
\item{X11}{A first stage covariate. A normally distributed continuous variable.}
\item{X12}{A first stage covariate. A continuous variable = X11^4.}
\item{A1}{The first stage treatment. A binary variable.}
\item{T1}{The time from the beginning of the first stage to the event or to 
          stage 2 entry, whichever comes first.}
\item{X21}{A second stage covariate. A normally distributed continuous variable.}
\item{X22}{A second stage covariate. A continuous variable = X21^3.}
\item{A2}{The second stage treatment. A binary variable.}
\item{T2}{The time from the beginning of the second stage to the event 
          defined only for subjects who enter the second stage.}
\item{delta}{Event indicator.}
}

Note: For participants who experienced the event during stage 1, i.e., did
  not continue to stage 2, the "survival time" is T1. For participants that
  entered stage 2, the "survival time" is T1 + T2.

twoStageSurv is a dataset generated to mimic a simple two-stage
  trial without censoring. The data.frame contains 1000 observations 
  with 9 columns: 
\describe{
\item{X11}{A first stage covariate. A normally distributed continuous variable.}
\item{X12}{A first stage covariate. A continuous variable = X11^4.}
\item{A1}{The first stage treatment. A binary variable.}
\item{T1}{The time from the beginning of the first stage to the event or to 
          stage 2 entry, whichever comes first.}
\item{X21}{A second stage covariate. A normally distributed continuous variable.}
\item{X22}{A second stage covariate. A continuous variable = X21^3.}
\item{A2}{The second stage treatment. A binary variable.}
\item{T2}{The time from the beginning of the second stage to the event 
          non-zero only for subjects who did not have an event in Stage I.}
}

Note: The "survival time" is T1 + T2.
}
\usage{
data(twoStageCont)

data(twoStageCens)

data(twoStageSurv)
}
\description{
These datasets are provided only to facilitate examples. They are not based 
  on or representative of any real-world applications.
}
\keyword{datasets}
