% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chp14.R
\name{Chapter14}
\alias{Chapter14}
\title{Chapter 14: Survival Analysis}
\value{
No function defined for Chapter 14.
}
\description{
Examples for Chapter 14, \emph{Survival Analysis}.
}
\examples{
library(DanielBiostatistics10th)
library(survival)
library(ggplot2)
library(ggfortify)

# Example 14.3.1; Page 756 (10th ed), Page 652 (11th ed) 
head(EXA_C14_S03_01)
head(d1431 <- within(EXA_C14_S03_01, expr = {
  TIME = .difftime(TIME, units = 'months')
  OS = Surv(TIME, event = (VITAL != 'ned')) # ?survival::Surv # create a time-to-event variable
}))
class(d1431$OS) # 'Surv'
head(d1431$OS)
summary(sf_1431 <- survfit(OS ~ TUMOR, data = d1431)) # Table 14.3.2
# ?survival::survfit # Kaplan-Meier estimates for the survival function
autoplot(sf_1431) + xlim(0, 120) + labs(title = 'Figure 14.3.1')
# ?ggfortify:::autoplot.survfit # to plot the Kaplan-Meier curves

# Example 14.4.1; Page 764 (10th ed), Page 659 (11th ed) 
survdiff(OS ~ TUMOR, data = d1431, rho = 0)
# ?survival::survdiff(..., rho = 0) # log rank test to compare survival functions

# Example 14.5.1; Page 769 (10th ed), Page 663 (11th ed)  
head(EXA_C14_S05_01)
head(d1451 <- within(EXA_C14_S05_01, expr = {
  time = .difftime(time, units = 'weeks')
  PFS = Surv(time, status)
  drug = relevel(structure(drug, levels = c('Opiate', 'Other'), class = 'factor'), ref = 'Other')
}))
summary(model1_1451 <- coxph(PFS ~ drug + age, data = d1451))
# ?survival::coxph # Cox proportional hazard model
# 'Opiate' has higher hazard compared to Drug='Other' (hazard ratio (HR) = 9.407, p < .001)
# With 'proportional hazard' assumption, 
# ... we don't need to discuss Opiate vs. Other at any specific time point
confint(model1_1451)
# 'age' is not significant (p = .772), so it should be removed from the model
summary(model2_1451 <- coxph(PFS ~ drug, data = d1451))
confint(model2_1451)
# 'Opiate' has higher hazard compared to Drug='Other' (hazard ratio (HR) = 9.923, p < .001)
autoplot(survfit(PFS ~ drug, data = d1451)) + labs(title = 'Figure 14.5.1')
}
