% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_cols.R
\name{sample_modifiers}
\alias{sample_modifiers}
\alias{unique_sample}
\alias{na_rand}
\alias{levels_rand}
\title{Modify sample with desired condition}
\usage{
unique_sample(sim_expr, ..., unique = TRUE, n_name = "n", n_iter = 10)

na_rand(sample_vec, na_ratio, not_null = FALSE)

levels_rand(sample_vec, levels_ratio, unique)
}
\arguments{
\item{sim_expr}{Expression to be evaluated in order to get column sample.}

\item{...}{Parameters and their values that are used in \code{sim_expr}.}

\item{unique}{If TRUE the function will try to simulate unique values.}

\item{n_name}{Name of the parameter providing sample length (for example 'n' for \code{rnorm} and 'size' for \code{sample}).}

\item{n_iter}{Number of iteration to make to assure the returned values are unique.}

\item{sample_vec}{Vector to which NA values should be injected.}

\item{na_ratio}{Ratio (in terms of column length) of NA values to attach to the sample.}

\item{not_null}{Information whether NA's are allowed.}

\item{levels_ratio}{Ratio of unique levels in terms of whole sample length.}
}
\description{
The set of function that allows to perform most common operations ion data sample.
}
\details{
\code{unique_sample} - takes simulation expression and assures the expression will be executed as many times as needed to return unique result sample.
\code{na_rand} - attaches NA values to the sample according to provided NA's ratio.
\code{levels_rand} - takes provided number of sample levels, and assures the returned sample have as many levels as requested.
}
\examples{

unique_sample(rnorm(n, mean = my_mean), n = 10, my_mean = 2)
unique_sample(sample(values, size, replace = TRUE), size = 10, values = 1:10, n_name = "size")

\dontrun{
  ## In 10 iterations it was not possible to simulate 6 unique values from the vector 1:5
  unique_sample(sample(values, size, replace = TRUE), size = 6, values = 1:5, n_name = "size")
}

na_rand(1:10, na_ratio = 0.5)

}
