% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConfig.R
\name{getConfig}
\alias{getConfig}
\title{Create a Point Configuration from a Distance Matrix}
\usage{
getConfig(D, d)
}
\arguments{
\item{D}{an nxn Euclidean distance matrix}

\item{d}{the dimension for the configuration}
}
\value{
\item{Y}{an nxd matrix containing the d-dimensional point configuration}
\item{Accuracy}{the ratio of the sum of retained eigenvalues to the sum of all n eigenvalues obtained during decomposition}
}
\description{
\code{getConfig} - given an nxn Euclidean distance matrix, produces a d-dimensional
point configuration of size n via eigendecomposition
}
\details{
Given a distance matrix D, transform to a semi-definite matrix S using the linear transformation \eqn{\tau(D)}.
Using S, compute the eigen-decomposition \eqn{S = ULV'}, where L is a diagonal matrix containing the singular-values of S,
and the columns of U contain the eigen-vectors. A point configuration X is then computed as:

\deqn{X = US^{.5}}

To compute a configuration in d dimensions, the first d eigenvalues of S are used.
}
\examples{
set.seed(1337)
D <- matrix(c(0,3,4,3,4,3,
             3,0,1,NA,5,NA,
             4,1,0,5,NA,5,
             3,NA,5,0,1,NA,
             4,5,NA,1,0,5,
             3,NA,5,NA,5,0),byrow=TRUE, nrow=6)
d <- 3
DStar <- dpf(D,d)$D

getConfig(DStar,3)

}

