% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_emd.R
\name{plot_emd}
\alias{plot_emd}
\title{Plot a decomposition}
\usage{
plot_emd(
  emd = NULL,
  xy = NULL,
  ini = NULL,
  dt = NULL,
  m = NULL,
  mode = NULL,
  repl = 1,
  size.xy = 5,
  size.dt = 25,
  style = 2,
  xylim = NULL,
  dtlim = NULL,
  inilim = NULL,
  vertical = TRUE,
  adapt.axis = FALSE,
  adapt.last = TRUE,
  select = NULL,
  over = NULL,
  s = list(type = "o", pch = 19, cex = 0.5),
  o = list(type = "l", col = "blue", lwd = 2),
  i = list(type = "o", pch = 19, cex = 0.5),
  e = list(type = "l", col = "red", lwd = 2),
  la = list(h = c(), v = c(), col = "red", xpd = FALSE),
  ls = list(),
  li = list(col = "grey", lty = 5),
  box = TRUE,
  ax = list(),
  ay = list(),
  parg = list(),
  title = TRUE,
  t1 = "Signal",
  t2 = "Mode",
  pdf = TRUE,
  name = "EMD",
  ext = ".pdf",
  dir = tempdir(),
  track = TRUE,
  openfile = TRUE
)
}
\arguments{
\item{emd}{an emd object}

\item{xy}{the original signal. Is overridden by emd.}

\item{ini}{an optional vector of length n of the eventual initial Intrinsic
Mode Function xy would be a demodulation of, if it is a demodulation.}

\item{dt}{the depth/time. Is overridden by emd.}

\item{m}{a matrix with columns of same length that xy, made of the
decomposition of the signal. Is overridden by emd.}

\item{mode}{which modes/decompositions to plot}

\item{repl}{the replication of decompositions in m. Is overridden by emd.}

\item{size.xy, size.dt}{the size i inches of each individual plot in pdf}

\item{style}{whether to not plot the original signal (style = 0), to plot it
as the first signal (style = 1), or to plot it before each individual mode
(style = 2, is the default)}

\item{xylim, dtlim, inilim}{the boundaries for the plots (inilim stands for the
xy boundaries of the plot of the initial IMF xy is a demodulation of, if
applicable)}

\item{vertical}{whether to have the depth/time [dt] axis vertically
(geologist convention) or horizontaly (climatologist convention)}

\item{adapt.axis}{whether to let the plot adapt the axis to see the
variability of the decompositions. The default os to have a comparable x axis
for each plots}

\item{adapt.last}{whether to adapt the last plot as a residue (if TRUE the
x axis will be identical to the one of the signal, not centered on 0)}

\item{select}{the components to plot}

\item{over}{which modes/decompositions will be cumulated and added to the
signal plotted at their left or above them (if style = 2)}

\item{s, o, i, e}{lists of parameters to feed lines, for the original signal,
the cumulated modes/decompositions overlapping it, the
modes/decompositions themselves, and the enveloppe of the initial signal
used for demodulation if it applies, respectively.}

\item{la, ls, li}{lists of parameters to provide the abline function (makes
personalised lines for you to have a better grasp of the data). la will plot
on all panels, ls on the signal ones, and li on the modes ones.}

\item{box}{whether to draw boxes around the plots}

\item{ax, ay}{lists of parameters to feed minorAxis, the function making the
axes, for the x and y axes}

\item{parg}{list of parameters to feed par}

\item{title}{whether to write titles}

\item{t1}{the title for the signal}

\item{t2}{the title for the modes}

\item{pdf}{whether to plot as a pdf}

\item{name, ext, dir, track, openfile}{parameters for the pdfDisplay function,
namely the name of the pdf file, its extension (if you want to make a .svg
file you can), the directory of the file, whether to track the changes
(if you use sumatrapdf as a default pdf reader you can set it to F and it
will avoid creating too many pdf files), and whether to directly open the
file}
}
\description{
General plot for a complete decomposition (that can be
summed back to the original signal)
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5) + 0.01 * t

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7,
                 repl = 10, comb = 10, factor_noise = 10,
                 speak = TRUE)

plot_emd(dec, select = c(4,6), pdf = FALSE)
\donttest{
plot_emd(dec, dir = tempdir())}


}
