% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_learners.R
\name{metalearner_ensemble}
\alias{metalearner_ensemble}
\title{metalearner_ensemble}
\usage{
metalearner_ensemble(
  data,
  cov.formula,
  treat.var,
  meta.learner.type,
  learners = c("SL.glmnet", "SL.xgboost", "SL.ranger", "SL.nnet"),
  nfolds = 5,
  binary.outcome = TRUE
)
}
\arguments{
\item{data}{\code{data.frame} object of data}

\item{cov.formula}{formula description of the model y ~ x(list of covariates)}

\item{treat.var}{string for the name of treatment variable.}

\item{meta.learner.type}{string specifying is the S-learner and
\code{"T.Learner"} for the T-learner model.}

\item{learners}{vector for super learner ensemble that includes extreme gradient
boosting, glmnet, random forest, and neural nets.}

\item{nfolds}{number of folds for cross-validation. Currently supports up to
5 folds.}

\item{binary.outcome}{logical specifying predicted outcome variable will take
binary values or proportions.}
}
\value{
\code{list} of predicted outcome values and CATEs estimated by the meta
learners for each observation.
}
\description{
\code{metalearner_ensemble} implements the S-learner and T-learner for
estimating CATE using the super learner ensemble method. The super learner in
this case includes the following machine learning algorithms:
extreme gradient boosting, glmnet (elastic net regression), random forest and
neural nets.
}
\examples{
# load dataset
data(exp_data)
#load SuperLearner package
library(SuperLearner)
# estimate CATEs with S Learner
set.seed(123456)
slearner <- metalearner_ensemble(cov.formula = support_war ~ age +
                                  income + employed + job_loss,
                                data = exp_data,
                                treat.var = "strong_leader",
                                meta.learner.type = "S.Learner",
                                learners = c("SL.glm"),
                                nfolds = 5,
                                binary.outcome = TRUE)

\donttest{
# estimate CATEs with T Learner
set.seed(123456)
tlearner <- metalearner_ensemble(cov.formula = support_war ~ age + income +
                                  employed  + job_loss,
                                  data = exp_data,
                                  treat.var = "strong_leader",
                                  meta.learner.type = "T.Learner",
                                  learners = c("SL.xgboost","SL.ranger",
                                               "SL.nnet"),
                                  nfolds = 5,
                                  binary.outcome = TRUE)
                                  }

}
