% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.frequency.R
\name{ds.frequency}
\alias{ds.frequency}
\title{Barplot parameters}
\usage{
ds.frequency(data, select=NULL, tojson=FALSE)
}
\arguments{
\item{data}{A vector, matrix or data frame which includes at least one factor/character.}

\item{select}{Select one or more specific nominal variables to calculate their corresponding frequencies, 
if it's not specified the result corresponds to frequencies of every factor variable in the data.}

\item{tojson}{If TRUE the results are returned in json format, default returns a list}
}
\description{
This function calculates the frequencies and the relative frequencies of factors/characters of the input dataset.
}
\details{
This function returns a list with the frequencies and relative frequencies of factors/characters 
of the input dataset.
}
\examples{
# with data frame as an input and a selected column to calculate its frequencies
ds.frequency(iris, select = "Species", tojson = FALSE)

# with data frame as an input without a selected column and json output
ds.frequency(iris, tojson = TRUE)

# OpenBudgets.eu Dataset Example:
Wuppertal_df
ds.frequency(Wuppertal_df, select = "Produkt", tojson = FALSE)

}
\seealso{
\code{\link{ds.analysis}}, \code{\link{open_spending.ds}}
}
\author{
Kleanthis Koupidis
}
