% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_appli.R
\name{fast.Discrete}
\alias{fast.Discrete}
\title{Fast application of discrete procedures}
\usage{
fast.Discrete(
  counts,
  alternative = "greater",
  input = "noassoc",
  alpha = 0.05,
  direction = "su",
  adaptive = FALSE
)
}
\arguments{
\item{counts}{a data frame of two or four columns and any number of
lines; each line representing a 2x2 contingency table to
test. The number of columns and what they must contain
depend on the value of the \code{input} argument (see Details
section of \link{fisher.pvalues.support}).}

\item{alternative}{same argument as in \link{fisher.test}. The three
possible values are \code{"greater"} (default), \code{"two.sided"}
or \code{"less"} (may be abbreviated).}

\item{input}{the format of the input data frame (see Details section
of \link{fisher.pvalues.support}. The three possible values
are \code{"noassoc"} (default), \code{"marginal"} or \code{"HG2011"}
(may be abbreviated).}

\item{alpha}{the target FDR level, a number strictly between 0 and 1.}

\item{direction}{a character string specifying whether to conduct a step-up (\code{direction="su"}, by default) or step-down procedure (\code{direction="sd"}).}

\item{adaptive}{a boolean specifying whether to conduct an adaptive procedure or not.}
}
\value{
A \code{DiscreteFDR} S3 class object whose elements are:
\item{Rejected}{Rejected raw p-values}
\item{Indices}{Indices of rejected hypotheses}
\item{Num.rejected}{Number of rejections}
\item{Adjusted}{Adjusted p-values (only for step-down direction).}
\item{Method}{Character string describing the used algorithm, e.g. 'Discrete Benjamini-Hochberg procedure (step-up)'}
\item{Signif.level}{Significance level \code{alpha}}
\item{Data$raw.pvalues}{The values of \code{raw.pvalues}}
\item{Data$pCDFlist}{The values of \code{pCDFlist}}
\item{Data$data.name}{The variable name of the \code{counts} dataset}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Apply the [HSU], [HSD], [AHSU] or [AHSD] procedure,
without computing the critical constants,
to a data set of 2x2 contingency tables using Fisher's exact tests.

\strong{Note}: In future versions, this function will be removed and replaced by a
more flexible one, which will not be limited to Fisher's exact test.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

DBH.su <- fast.Discrete(counts = df, input = "noassoc", direction = "su")
summary(DBH.su)

DBH.sd <- fast.Discrete(counts = df, input = "noassoc", direction = "sd")
DBH.sd$Adjusted
summary(DBH.sd)

ADBH.su <- fast.Discrete(counts = df, input = "noassoc", direction = "su", adaptive = TRUE)
summary(ADBH.su)

ADBH.sd <- fast.Discrete(counts = df, input = "noassoc", direction = "sd", adaptive = TRUE)
ADBH.sd$Adjusted
summary(ADBH.sd)

}
\seealso{
\link{fisher.pvalues.support}, \link{discrete.BH}
}
