% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Disequilibrium.R
\name{summary.DE}
\alias{summary.DE}
\title{Summary method for class 'DE'}
\usage{
\method{summary}{DE}(object, ...)
}
\arguments{
\item{object}{An object of class \code{DE} for which a summary is desired.}

\item{...}{Unused}
}
\value{
A matrix summary of estimates is returned.  The columns are:

\describe{

\item{Estimate}{Maximum likelihood point estimate.}

\item{Std. Error}{Asymptotic standard error estimate of maximum likelihood point estimators using numerical hessian.}

\item{z value}{z value for zero value null hypothesis using asymptotic standard error estimate.}

\item{Pr(>|z|)}{P value for a two sided null hyptothesis test using the z value.}

}
}
\description{
Summary method for class 'DE'
}
\examples{
set.seed(1775)
library(MASS)
beta01 = c(1,1)
beta02 = c(-1,-1)
N = 10000
SigmaEps = diag(2)
SigmaX = diag(2)
MuX = c(0,0)
par0 = c(beta01, beta02, SigmaX[1, 1], SigmaX[1, 2], SigmaX[2, 2])

Xgen = mvrnorm(N,MuX,SigmaX)
X1 = cbind(1,Xgen[,1])
X2 = cbind(1,Xgen[,2])
X = list(X1 = X1,X2 = X2)
eps = mvrnorm(N,c(0,0),SigmaEps)
eps1 = eps[,1]
eps2 = eps[,2]
Y1 = X1 \%*\% beta01 + eps1
Y2 = X2 \%*\% beta02 + eps2
Y = pmin(Y1,Y2)
df = data.frame(Y = Y, X1 = X1, X2 = X2)

results = DE(formula = Y ~ X1 | X2, data = df)

summary(results)

}
