% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llogis.R
\name{llogis}
\alias{llogis}
\alias{dLlogis}
\alias{pLlogis}
\alias{expValLlogis}
\alias{varLlogis}
\alias{kthMomentLlogis}
\alias{expValLimLlogis}
\alias{expValTruncLlogis}
\alias{stopLossLlogis}
\alias{meanExcessLlogis}
\alias{VatRLlogis}
\alias{TVatRLlogis}
\title{Loglogistic Distribution}
\usage{
dLlogis(x, shape, rate = 1/scale, scale = 1/rate)

pLlogis(q, shape, rate = 1/scale, scale = 1/rate, lower.tail = TRUE)

expValLlogis(shape, rate = 1/scale, scale = 1/rate)

varLlogis(shape, rate = 1/scale, scale = 1/rate)

kthMomentLlogis(k, shape, rate = 1/scale, scale = 1/rate)

expValLimLlogis(d, shape, rate = 1/scale, scale = 1/rate)

expValTruncLlogis(d, shape, rate = 1/scale, scale = 1/rate, less.than.d = TRUE)

stopLossLlogis(d, shape, rate = 1/scale, scale = 1/rate)

meanExcessLlogis(d, shape, rate = 1/scale, scale = 1/rate)

VatRLlogis(kap, shape, rate = 1/scale, scale = 1/rate)

TVatRLlogis(kap, shape, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{x}{vector of quantiles.}

\item{shape}{shape parameter \eqn{\tau}{tau}, must be positive}

\item{rate}{rate parameter \eqn{\beta}{beta}, must be positive.}

\item{scale}{alternative parameterization to the rate parameter, scale = 1 / rate.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{k}{kth-moment.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{dLlogis}}}{ gives the probability density function (PDF).}
 \item{\code{\link{pLlogis}}}{ gives the cumulative density function (CDF).}
 \item{\code{\link{expValLlogis}}}{ gives the expected value.}
 \item{\code{\link{varLlogis}}}{ gives the variance.}
 \item{\code{\link{kthMomentLlogis}}}{ gives the kth moment.}
 \item{\code{\link{expValLimLlogis}}}{ gives the limited mean.}
 \item{\code{\link{expValTruncLlogis}}}{ gives the truncated mean.}
 \item{\code{\link{stopLossLlogis}}}{ gives the stop-loss.}
 \item{\code{\link{meanExcessLlogis}}}{ gives the mean excess loss.}
 \item{\code{\link{VatRLlogis}}}{ gives the Value-at-Risk.}
 \item{\code{\link{TVatRLlogis}}}{ gives the Tail Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Loglogistic distribution with shape parameter \eqn{\tau}{tau} and scale
parameter \eqn{\lambda}{lambda}.
}
\details{
The loglogistic distribution with shape parameter \eqn{\tau}{t} and scale parameter
  \eqn{\lambda}{lam} has density:
  \deqn{\frac{\tau \lambda^\tau x^{\tau -1}}{(\lambda^{\tau }+x^{\tau })^{2}}}{f(x) = t lam^t x^(t - 1) / (lam^t + x^t)^2}
for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\lambda, \tau > 0}{lam, t > 0}.
}
\examples{
dLlogis(x = 2, shape = 2, scale = 4)

# With scale parameter
pLlogis(q = 3, shape = 3, scale = 5)

# With rate parameter
pLlogis(q = 3, shape = 3, rate = 0.2)

# Survival function
pLlogis(q = 3, shape = 3, rate = 0.2, lower.tail = FALSE)

expValLlogis(shape = 2, scale = 4)

varLlogis(shape = 3, scale = 4)

kthMomentLlogis(k = 3, shape = 5, scale = 4)

expValLimLlogis(d = 2, shape = 2, scale = 4)

# With rate parameter
expValTruncLlogis(d = 2, shape = 2, scale = 4)

# Values greater than d
expValTruncLlogis(d = 2, shape = 2, scale = 4, less.than.d = FALSE)

stopLossLlogis(d = 2, shape = 2, scale = 4)

meanExcessLlogis(d = 3, shape = 2, scale = 4)

# With scale parameter
VatRLlogis(kap = .2, shape = 2, scale = 4)

# With rate parameter
VatRLlogis(kap = .2, shape = 2, rate = 0.25)

# With scale parameter
TVatRLlogis(kap = .2, shape = 3, scale = 4)

# With rate parameter
TVatRLlogis(kap = .2, shape = 3, rate = 0.25)

}
