% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BinomialBacktest.R
\name{BinomialBacktest}
\alias{BinomialBacktest}
\title{Carries out the binomial backtest for a VaR risk measurement model.}
\usage{
BinomialBacktest(x, n, cl)
}
\arguments{
\item{x}{Number of failures}

\item{n}{Number of observations}

\item{cl}{Confidence level for VaR}
}
\value{
Probability that the VaR model is correct
}
\description{
The basic idea behind binomial backtest (also called basic frequency
test) is to test whether the observed frequency of losses that exceed VaR is
consistent with the frequency of tail losses predicted by the mode. Binomial
Backtest carries out the binomial backtest for a VaR risk measurement model
for specified VaR confidence level and for a one-sided alternative
hypothesis (H1).
}
\examples{
# Probability that the VaR model is correct for 3 failures, 100 number
   # observations and  95\% confidence level
   BinomialBacktest(55, 1000, 0.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, Kevin. Measuring Market Risk, Wiley, 2007.

Kupiec, Paul. Techniques for verifying the accuracy of risk measurement
models, Journal of Derivatives, Winter 1995, p. 79.
}

