% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BootstrapVaR.R
\name{BootstrapVaR}
\alias{BootstrapVaR}
\title{Bootstrapped VaR for specified confidence level}
\usage{
BootstrapVaR(Ra, number.resamples, cl)
}
\arguments{
\item{Ra}{Vector corresponding to profit and loss distribution}

\item{number.resamples}{Number of samples to be taken in bootstrap procedure}

\item{cl}{Number corresponding to Value at Risk confidence level}
}
\value{
Bootstrapped VaR
}
\description{
Estimates the bootstrapped VaR for confidence level and holding period
implied by data frequency.
}
\examples{
# Estimates bootstrapped VaR for given parameters
   a <- rnorm(100) # generate a random profit/loss vector
   BootstrapES(a, 50, 0.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

