% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CornishFisherVaR.R
\name{CornishFisherVaR}
\alias{CornishFisherVaR}
\title{Corn-Fisher VaR}
\usage{
CornishFisherVaR(mu, sigma, skew, kurtosis, cl)
}
\arguments{
\item{mu}{Mean of P/L distribution}

\item{sigma}{Variance of of P/L distribution}

\item{skew}{Skew of P/L distribution}

\item{kurtosis}{Kurtosis of P/L distribution}

\item{cl}{VaR confidence level}
}
\value{
Value at Risk
}
\description{
Function estimates the VaR for near-normal P/L using the Cornish-Fisher
adjustment for non-normality, for specified confidence level.
}
\examples{
# Estimates Cornish-Fisher VaR for given parameters
   CornishFisherVaR(3.2, 5.6, 2, 3, .9)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Zangri, P. A VaR methodology for portfolios that include options.
RiskMetrics Monitor, First quarter, 1996, p. 4-12.
}

