% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HSESDFPerc.R
\name{HSESDFPerc}
\alias{HSESDFPerc}
\title{Percentile of historical simulation ES distribution function}
\usage{
HSESDFPerc(Ra, perc, cl)
}
\arguments{
\item{Ra}{Vector of daily P/L data}

\item{perc}{Desired percentile and is scalar}

\item{cl}{VaR confidence level and is scalar}
}
\value{
Value of percentile of VaR distribution function
}
\description{
Estimates percentiles of historical simulation ES distribution
function, using theory of order statistics, for specified confidence level.
}
\examples{
# Estimates Percentiles for random standard normal returns and given perc
   # and cl
   Ra <- rnorm(100)
   HSESDFPerc(Ra, .75, .95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

