% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/InsuranceVaR.R
\name{InsuranceVaR}
\alias{InsuranceVaR}
\title{VaR of Insurance Portfolio}
\usage{
InsuranceVaR(mu, sigma, n, p, theta, deductible, number.trials, cl)
}
\arguments{
\item{mu}{Mean of returns}

\item{sigma}{Volatility of returns}

\item{n}{Number of contracts}

\item{p}{Probability of any loss event}

\item{theta}{Expected profit per contract}

\item{deductible}{Deductible}

\item{number.trials}{Number of simulation trials}

\item{cl}{VaR confidence level}
}
\value{
VaR of the specified portfolio
}
\description{
Generates Monte Carlo VaR for insurance portfolio in Chapter 6.5
}
\examples{
# Estimates VaR of Insurance portfolio with given parameters
   InsuranceVaR(.8, 1.3, 100, .6, 21,  12, 50, .95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

