% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LogNormalESFigure.R
\name{LogNormalESFigure}
\alias{LogNormalESFigure}
\title{Figure of lognormal VaR and ES and pdf against L/P}
\usage{
LogNormalESFigure(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 investment Size of investment

 cl VaR confidence level and should be scalar

 hp VaR holding period in days and should be scalar}
}
\description{
Gives figure showing the VaR and ES and probability distribution function
against L/P of a portfolio assuming geometric returns are normally
distributed, for specified confidence level and holding period.
}
\examples{
# Plots lognormal VaR, ES and pdf against L/P data for given returns data
   data <- runif(5, min = 0, max = .2)
   LogNormalESFigure(returns = data, investment = 5, cl = .95, hp = 90)

   # Plots lognormal VaR, ES and pdf against L/P data with given parameters
   LogNormalESFigure(mu = .012, sigma = .03, investment = 5, cl = .95, hp = 90)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

