% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkDrugUtilisation.R
\name{benchmarkDrugUtilisation}
\alias{benchmarkDrugUtilisation}
\title{Run benchmark of drug utilisation cohort generation}
\usage{
benchmarkDrugUtilisation(
  cdm,
  ingredient = "acetaminophen",
  alternativeIngredient = c("ibuprofen", "aspirin", "diclofenac"),
  indicationCohort = NULL
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object.}

\item{ingredient}{Name of ingredient to benchmark.}

\item{alternativeIngredient}{Name of ingredients to use as alternative
treatments.}

\item{indicationCohort}{Name of a cohort in the cdm_reference object to use
as indicatiomn.}
}
\value{
A summarise_result object.
}
\description{
Run benchmark of drug utilisation cohort generation
}
\examples{
\donttest{
CDMConnector::requireEunomia()
con <- duckdb::dbConnect(duckdb::duckdb(), CDMConnector::eunomiaDir())
cdm <- CDMConnector::cdmFromCon(con = con, cdmSchema = "main", writeSchema = "main")

timings <- benchmarkDrugUtilisation(cdm)

timings
}

}
