% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableDrugRestart}
\alias{tableDrugRestart}
\title{Format a drug_restart object into a visual table.}
\usage{
tableDrugRestart(
  result,
  header = c("cdm_name", "cohort_name"),
  groupColumn = "variable_name",
  type = "gt",
  hide = c("censor_date", "restrict_to_first_discontinuation", "follow_up_days",
    "cohort_table_name", "incident", "switch_cohort_table"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default
values.}
}
\value{
A table with a formatted version of summariseDrugRestart() results.
}
\description{
Format a drug_restart object into a visual table.
}
\examples{
\donttest{
cdm <- mockDrugUtilisation()

conceptlist <- list("a" = 1125360, "b" = c(1503297, 1503327))
cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "switch_cohort",
  conceptSet = conceptlist
)

result <- cdm$cohort1 |>
  summariseDrugRestart(switchCohortTable = "switch_cohort")

tableDrugRestart(result)
}

}
