% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPdfs.R
\name{getPdfs}
\alias{getPdfs}
\title{(Re)Calculate model densities with given parameters and time grid}
\usage{
getPdfs(resDecision, tt, pars, DstarM = TRUE, fun.density = Voss.density,
  args.density = list())
}
\arguments{
\item{resDecision}{output of \code{\link{estDstarM}}.}

\item{tt}{Time grid to calculate the model densities on.}

\item{pars}{Model parameters, can be a matrix where every column is a set of parameters.}

\item{DstarM}{Logical. Do the model pdfs also describe the nondecision distribution?}

\item{fun.density}{density function to calculate pdfs from.}

\item{args.density}{Additional arguments for fun.density}
}
\value{
A matrix containing model pdfs.
}
\description{
This function is a convenience function for calculating model pdfs for
multiple sets of parameters at a specified timegrid. If \code{resDecision} is supplied,
the density function and any additional arguments for the density function will be
extracted from that object. If \code{pars} is missing these will also be extracted from
this object. This function is intended to recalculate model densities at a new timegrid.
}
