% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E4.part1.ExtractRawEDA.R
\name{E4_EDA_Process.part1.ExtractRawEDA}
\alias{E4_EDA_Process.part1.ExtractRawEDA}
\title{EDA Processing Part 1: Extract and filter EDA data}
\usage{
E4_EDA_Process.part1.ExtractRawEDA(participant_list, ziplocation,
  rdslocation.EDA, summarylocation, EDA_low_cut = 0, LowPctCutoff = 1,
  EDA_high_cut = 1000, HighPctCutoff = 1, KeepRejectFlag = TRUE)
}
\arguments{
\item{participant_list}{list of participant numbers NOTE: This should match the names of the folders (e.g., participant 1001's data should be in a folder called "1001")}

\item{ziplocation}{folder location where the participant-level subfolders are (make sure that it ends in /)}

\item{rdslocation.EDA}{folder location where you want the RDS outputs to go (make sure that it ends in /)}

\item{summarylocation}{folder location where you want participant level summaries to be saved.}

\item{EDA_low_cut}{This is a HIGH PASS filter. What EDA value (in microsiemens) should be used as the minimum cutoff (0 = cuts off samples that have 0us)}

\item{LowPctCutoff}{what percentage of samples in a five-second block must contain the low cutoff in order to exclude that block? (e.g., if .5, there must be at least 50 percent of the samples below the low-cut value to exclude the 5-sec block)}

\item{EDA_high_cut}{This is a LOW PASS filter. What EDA value (in microsiemens) should be used as the maximum cutoff (100 = cuts off samples above 100us)}

\item{HighPctCutoff}{what percentage of samples in a five-second block must contain the high cutoff in order to exclude that block?}

\item{KeepRejectFlag}{Do you want to keep the flag that shows which data the high and low pass filters rejected? If you want to run the diagnostic steps, you must keep this. Defaults to TRUE.}
}
\description{
This function allows you extract and filter EDA data. It will output raw data, filtered data (using user-specified high and low pass filters + a butterworth filter), and filtered + feature-scaled ([0,1]) data. It will also provide summary data at the participant and session level.
Inputs are: (1) List of participant numbers and (2) location where ZIP folders are stored. Outputs are: (1) one RDS file per participant with all data, (2) summary file that gives participant-level meta-data.
}
\examples{
E4_EDA_Process.part1.ExtractRawEDA(participant_list=c(1001:1003),
ziplocation=paste(system.file(package="E4tools"),"/extdata/E4_demo_data/",sep=""),
rdslocation.EDA=paste(tempdir(),"/extdata/output/raw_EDA/",sep=""),
summarylocation=paste(tempdir(),"/extdata/output/summaries/",sep=""),
EDA_low_cut=0.001,LowPctCutoff=.75,
EDA_high_cut=25,HighPctCutoff=.75)
}
\keyword{EDA}
