% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdIS.R
\name{hdIS}
\alias{hdIS}
\title{Compute importance weights for  lasso, group lasso, scaled lasso or
scaled group lasso estimator under high-dimensional setting}
\usage{
hdIS(PBsample, PETarget, sig2Target, lbdTarget, TsA.method = "default",
  log = TRUE, parallel = FALSE, ncores = 2L)
}
\arguments{
\item{PBsample}{bootstrap samples of class \code{PB} from \code{\link{PBsampler}}.}

\item{PETarget, sig2Target, lbdTarget}{parameters of target distribution.
(point estimate of beta or \code{E(y)}, estimated variance of error and lambda)}

\item{TsA.method}{method to construct \code{T(eta(s),A)} matrix. See Zhou and Min(2017)
for details.}

\item{log}{logical. If \code{log = TRUE}, importance weight is computed in log scale.}

\item{parallel}{logical. If \code{parallel = TRUE}, uses parallelization.
Default is \code{parallel = FALSE}.}

\item{ncores}{integer. The number of cores to use for parallelization.}
}
\value{
importance weights of the proposed samples.
}
\description{
\code{hdIS} computes importance weights using samples
drawn by \code{\link{PBsampler}}. See the examples
below for details.
}
\details{
computes importance weights which is defined as (target density)/(proposal density),
 when the samples are drawn from the proposal
 distribution with the function \code{\link{PBsampler}} while the parameters of
 the target distribution are (PETarget, sig2Target, lbdTarget). \cr
 Say that we are interested in computing the expectation of a function of a random variable, \code{h(X)}.
 Let \code{f(x)} be the true or target distribution and \code{g(x)} be the proposal distribution.
 We can approximate the expectation, \code{E[h(X)]}, by a weighted average of samples, \code{x_i}, drawn from
 the proposal distribution as follows, \code{E[h(X)] = mean( h(x_i) * f(x_i)/h(x_i) )}.
}
\examples{
set.seed(1234)
n <- 10
p <- 30
Niter <-  10
Group <- rep(1:(p/10), each = 10)
Weights <- rep(1, p/10)
x <- matrix(rnorm(n*p), n)

# Target distribution parameter
PETarget <- rep(0, p)
sig2Target <- .5
lbdTarget <- .37

#
# Using non-mixture distribution
# ------------------------------
## Proposal distribution parameter
PEProp1 <- rep(1, p)
sig2Prop1 <- .5
lbdProp1 <- 1
PB <- PBsampler(X = x, PE_1 = PEProp1, sig2_1 = sig2Prop1,
 lbd_1 = lbdProp1, weights = Weights, group = Group, niter = Niter,
 type="grlasso", PEtype = "coeff")

hdIS(PB, PETarget = PETarget, sig2Target = sig2Target, lbdTarget = lbdTarget,
 log = TRUE)

#
# Using mixture distribution
# ------------------------------
# Target distribution parameters (coeff, sig2, lbd) = (rep(0,p), .5, .37)
# Proposal distribution parameters
#  (coeff, sig2, lbd) = (rep(0,p), .5, .37) & (rep(1,p), 1, .5)
#
#
PEProp1 <- rep(0,p); PEProp2 <- rep(1,p)
sig2Prop1 <- .5; sig2Prop2 <- 1
lbdProp1 <- .37; lbdProp2 <- .5

PBMixture <- PBsampler(X = x, PE_1 = PEProp1,
 sig2_1 = sig2Prop1, lbd_1 = lbdProp1, PE_2 = PEProp2,
 sig2_2 = sig2Prop2, lbd_2 = lbdProp2, weights = Weights, group = Group,
 niter = Niter, type = "grlasso", PEtype = "coeff")
hdIS(PBMixture, PETarget = PETarget, sig2Target = sig2Target, lbdTarget = lbdTarget,
 log = TRUE)
}
\references{
Zhou, Q. (2014), "Monte Carlo simulation for Lasso-type problems by estimator augmentation,"
Journal of the American Statistical Association, 109, 1495-1516.

Zhou, Q. and Min, S. (2017), "Estimator augmentation with applications in
high-dimensional group inference," Electronic Journal of Statistics, 11(2), 3039-3080.
}
