% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR_INMB_DIFF.R
\name{create_object_var_inmb_diff}
\alias{create_object_var_inmb_diff}
\title{Create an object var_inmb_diff}
\usage{
create_object_var_inmb_diff(sdc_ref, sdc_exp, sde_ref, sde_exp, rho,
  object_lambda)
}
\arguments{
\item{sdc_ref}{: standard deviation of costs in the reference group}

\item{sdc_exp}{: standard deviation of costs in the experimental group}

\item{sde_ref}{: standard deviation of effectiveness in the reference group}

\item{sde_exp}{: standard deviation of effectiveness in the experimental group}

\item{rho}{: coefficient of correlation between the difference in costs (dc) and the difference in effectiveness (de)}

\item{object_lambda}{: object containing the ceiling cost-effectiveness ratio or maximum acceptable cost of a unit of effectiveness. See \link{create_object_lambda}}
}
\value{
create_object_var_inmb_diff returns an object of class \link{VAR_INMB_DIFF} which inherits from the class \link{VAR_INMB_DIRECT}
}
\description{
The variance of the Incremental Net Monetary Benefit may also be calculated in a hypothetical situation when the standard deviation of costs and effectiveness in each group differ.
}
\examples{
## First, create a lambda object
object_lambda <- create_object_lambda (20000)
## Then, create a var_inmb_diff object
var_inmb_diff <- create_object_var_inmb_diff(sdc_ref=2100, sdc_exp=2100, sde_ref = 0.12,
sde_exp = 0.12, rho = 0.1,object_lambda = object_lambda)
}
\seealso{
\link{create_object_var_inmb_direct} to directly provide a value for the variance of the Incremental Net Monetary Benefit

\link{create_object_var_inmb} to calculate the theoretical standard deviation of the expected INB with the same standard deviation in the reference and the experimental group
}

