% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.EKC}
\alias{plot.EKC}
\title{Plot Empirical Kaiser Criterion (EKC) Plot}
\usage{
\method{plot}{EKC}(x, ...)
}
\arguments{
\item{x}{An object of class \code{EKC}, representing the results to be plotted.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function generates an Empirical Kaiser Criterion (EKC) plot to visualize the eigenvalues
of the actual data. The EKC method helps in determining the number of factors to retain by
identifying the point where the eigenvalues exceed the reference eigenvalue.
The plot provides a graphical representation to assist in factor selection.
}
\examples{
library(EFAfactors)
set.seed(123)

##Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## loading data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
 EKC.obj <- EKC(response)

 ## EKC plot
 plot(EKC.obj)

}

}
\seealso{
\link[EFAfactors]{EKC}
}
