#' Intelligence subtests from the Intelligence and Development Scales--2
#'
#' A matrix containing the bivariate correlations of the 14 intelligence subtests from the Intelligence and Development Scales--2 (IDS-2; Grob & Hagmann-von Arx, 2018), an intelligence and development test battery for children and adolescents aged 5 to 20 years, for the standardization and validation sample (N = 1,991). Details can be found in Grieder & Grob (2019).
#'
#'
#' @format A 14 x 14 matrix of bivariate correlations
#' \describe{
#'   \item{GS}{(numeric) - Geometric shapes.}
#'   \item{PL}{(numeric) - Plates.}
#'   \item{TC}{(numeric) - Two characteristics.}
#'   \item{CB}{(numeric) - Crossing out boxes.}
#'   \item{NL}{(numeric) - Numbers / letters.}
#'   \item{NLM}{(numeric) - Numbers / letter mixed.}
#'   \item{GF}{(numeric) - Geometric figures.}
#'   \item{RGF}{(numeric) - Rotated geometric figures.}
#'   \item{CM}{(numeric) - Completing matrices.}
#'   \item{EP}{(numeric) - Excluding pictures.}
#'   \item{CA}{(numeric) - Categories.}
#'   \item{OP}{(numeric) - Opposites.}
#'   \item{RS}{(numeric) - Retelling a story.}
#'   \item{DP}{(numeric) - Describing pictures.}
#'  }
#' @source Grieder, S., & Grob, A. (2019). Exploratory factor analyses of the intelligence and development scales--2: Implications for theory and practice. Assessment. Advance online publication. doi:10.1177/10731911198450
#' @source Grob, A., & Hagmann-von Arx, P. (2018). Intelligence and Development Scales--2 (IDS-2). Intelligenz- und Entwicklungsskalen für Kinder und Jugendliche.
#' [Intelligence and Development Scales for Children and Adolescents.]. Bern, Switzerland: Hogrefe.
"IDS2_R"
