% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELMSO.R
\name{reach.ELMSO}
\alias{reach.ELMSO}
\title{Calculating Reach from Main ELMSO Function}
\usage{
reach.ELMSO(bid, a, z)
}
\arguments{
\item{bid}{A p-dimensional vector of the bidded CPM at each website for a particular budget value}

\item{a}{A p-dimensional vector of steepness values for the cost curves associated with each website}

\item{z}{An n by p matrix of pageviews}
}
\value{
A value between 0 and 1 specifying the reach achieved with the given budget allocation.
}
\description{
This function allows you to calculate reach achieved at a given budget value from the ELMSO output.
}
\examples{
z=matrix(round(abs(rnorm(5000,0,0.7))),1000,5)
CPM.avg=c(3,4,5,6,7)
tau.values=rep(100,5) #Note tau here is in thousands of pageviews

allocation=ELMSO(z=z,CPM=CPM.avg,tau=tau.values)
reach.ELMSO(allocation$bid[,101],allocation$a,z)
}
\references{
Courtney Paulson, Lan Luo, and Gareth M. James (2018) Efficient Large-Scale Internet Media Selection Optimization for Online Display Advertising. Journal of Marketing Research: August 2018, Vol. 55, No. 4, pp. 489-506.
}
