% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{ess_summary.emc}
\alias{ess_summary.emc}
\alias{ess_summary}
\title{Effective Sample Size}
\usage{
\method{ess_summary}{emc}(
  emc,
  selection = "mu",
  stat = "min",
  stat_only = FALSE,
  digits = 1,
  ...
)

ess_summary(emc, ...)
}
\arguments{
\item{emc}{An emc object}

\item{selection}{A Character vector. Indicates which parameter types to check (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{stat}{A string. Should correspond to a function that can be applied to a vector,
which will be performed on the vector/rows or columns of the matrix of the parameters}

\item{stat_only}{Boolean. If \code{TRUE} will only return the result of the applied stat function,
otherwise returns both the stat result and the result of the function on all parameters.}

\item{digits}{Integer. How many digits to round the output to}

\item{...}{Optional additional arguments that can be passed to \code{get_pars}}
}
\value{
A matrix or vector of ESS values for the selected parameter type.
}
\description{
Returns the effective sample size (ESS) of the selected parameter type.
Full range of possible samples manipulations described in \code{get_pars}.
}
\examples{
ess_summary(samples_LNR, selection = "alpha")
}
