% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypervolume.overlap.R
\name{hypervolume.overlap}
\alias{hypervolume.overlap}
\title{Takes an emtools.species object and environmental layers, and constructs a hypervolume using the R package hypervolume}
\usage{
hypervolume.overlap(
  species.1,
  species.2,
  env = NA,
  reduction.factor = 0.1,
  ...
)
}
\arguments{
\item{species.1}{An enmtools.species or enmtools.hypervolume object}

\item{species.2}{An enmtools.species or enmtools.hypervolume object}

\item{env}{A stack of environmental rasters, required when enmtools.species objects are passed}

\item{reduction.factor}{Passed to hypervolume functions}

\item{...}{Extra parameters to be passed to enmtools.hypervolume}
}
\value{
A list containing a set of hypervolume objects and the overlap that was measured between them.
}
\description{
Takes an emtools.species object and environmental layers, and constructs a hypervolume using the R package hypervolume
}
\examples{
\dontrun{
install.extras(repos='http://cran.us.r-project.org')
data(euro.worldclim)
data(iberolacerta.clade)
mont <- iberolacerta.clade$species$monticola
cyr <- iberolacerta.clade$species$cyreni
env <- euro.worldclim[[c(1,8,12,17)]]
if(requireNamespace("hypervolume", quietly = TRUE)) {
    hypervolume.overlap(mont, cyr, env = env)
}
}
}
