% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PopulationClass.R
\docType{class}
\name{Population-class}
\alias{Population-class}
\title{Population}
\description{
The \code{Population} class allows for the collection of the parameters necessary
to characterise a biological population. It is an essentially useful class
in that no method associated with the population class can simulate its
dynamics. To do this, it is necessary to use the Metapopulation class,
which takes as input a list of populations (from one). The Population
class is also used to check that each of these parameters is compatible
with each other.
}
\details{
Thus to build an object of class \code{Ease}, it is necessary to have
defined an object \code{Genome}, as well as an object \code{MutationMatrix}
and an object \code{Selection} (even if it is neutral, see
\link[Ease]{setSelectNeutral}).
}
\section{Slots}{

\describe{
\item{\code{name}}{the name of the population.}

\item{\code{size}}{the size of the population.}

\item{\code{dioecy}}{logical indicating whether the population is dioecious or not
(hermaphrodite).}

\item{\code{selfRate}}{the selfing rate of the population}

\item{\code{demography}}{logical indicating whether the population has stochastic
demography (this does not include migration), i.e. non-constant size and
potentially population growth or decay, depending on the situation it is in.}

\item{\code{growthRate}}{growth rate of the population.}

\item{\code{initGenoFreq}}{A row matrix of the size of the genotype number
describing the initial allele frequencies common to all simulations}

\item{\code{genome}}{a \code{Genome} object}

\item{\code{initPopSize}}{initial population size, knowing that if the demography
is extinct, the initial population size will automatically be set equal to
the population size.}

\item{\code{selection}}{a \code{Selection} object}

\item{\code{mutMat}}{a \code{MutationMatrix} object}
}}

\author{
Ehouarn Le Faou
}
