% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.joincount.R
\name{eco.joincount}
\alias{eco.joincount}
\title{Join-Count statistic with Monte-Carlo test}
\usage{
eco.joincount(z, con, nsim = 99, test = c("permutation", "bootstrap"),
  alternative = c("auto", "two.sided", "greater", "less"), adjust = c("fdr",
  "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "none"),
  ncod = NULL)
}
\arguments{
\item{z}{vector for the analysis.}

\item{con}{An object of class listw or a weight square matrix, giving
the weights for the analysis.}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{test}{If "bootstrap", the program generates a bootstrap resampling and the
associated confidence intervals of the null hypothesis. If "permutation" (default)
a permutation test is made and the p value is calculated.}

\item{alternative}{The alternative hypothesis. If "auto" is selected (default) the
program determines the hypothesis by difference between the median of the simulations
and the observed value. Other options are: "two.sided", "greater" and "less".}

\item{adjust}{Correction method passed to \code{\link[stats]{p.adjust}}.
Default is "fdr".}

\item{ncod}{number of characters coding the information in each cell. For
example, if a cell contains "1" ncod =1, if contains "ab" or "12" ndcod = 2,
and so on.}
}
\description{
This program computes the Join-Count statistic for the data z,
with p values or a confidence interval for the null hypothesis.
}
\examples{
\dontrun{
data(eco.test)
require(adegenet)
con<-chooseCN(eco$XY, type = 1, result.type = "listw",
plot.nb = FALSE)
eco.joincount(2 * eco$GENIND$tab[, 3], con,
nsim = 99, ncod = 1)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

