% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{sim10}
\alias{sim10}
\title{Sim10 Co-occurrence Randomization Algorithm}
\usage{
sim10(speciesData, rowWeights = runif(dim(speciesData)[1]),
  colWeights = runif(dim(speciesData)[2]))
}
\arguments{
\item{speciesData}{binary presence-absence matrix
(rows = species, columns = sites).}

\item{rowWeights}{vector of positive values representing species weights.}

\item{colWeights}{vector of positive values representing site weights.}
}
\value{
Returns a binary presence-absence matrix with the same
dimensions and fill as the input matrix.
}
\description{
Randomizes a binary matrix speciesData by reshuffling all
elements. Rows and column probabilities are proportional to user-supplied
row and column weights, which define relative suitability probabilities for
species and sites. Makes a call to the vector_sample function.
}
\details{
This function incorporates vectors of weights for species and/or
sites to condition the simulation. These two vectors are used as outer
products to set cell probabilities for the entire matrix. Thus:
\deqn{p(cell_{ij})=p(row_i)p(col_j)}{p(cell_ij)=p(row_i)p(col_j)}
Weights must be positive real numbers. The algorithm will scale them so they
sum to 1.0, so they can be used in their natural units (e.g. island area,
species abudance), and will be scaled properly. If all species (or sites)
are assumed to be equally likely, the weight vector should be set to the
same constant for all elements.
}
\note{
sim10 allows users to incorporate independent data on species
occurrence probabilities and site suitabilities. This represents an
important conceptual advance over standard co-occurrence analyses, which
must infer these probabilities from the matrix itself. sim10 may generate
empty rows or columns, especially if weights are very small for some species
or sites. Also, the results may be sensitive to algebraic transformations
of the weights (x, x^2, log(x), etc.), and these transformations may be hard
to justify biologically. Nevertheless, sim10 is worth exploring for rich
data sets with site and species attributes.
}
\examples{
randomMatrix <- sim10(speciesData=matrix(rbinom(40,1,0.5),nrow=8))
}
\references{
Jenkins, D.G. 2006. In search of quorum effects in metacommunity
structure: species co-occurrence analyses. Ecology 87:1523-1531

Gotelli, N.J., G.R. Graves, and C. Rahbek. 2010. Macroecological
signals of species interactions in the Danish avifauna. Proceedings of the
National Academy of Sciences, U.S.A. 107: 530-535.
}
\seealso{
\code{\link{vector_sample}} for weighted vector sampling.
}

