% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{mutate_cond}
\alias{mutate_cond}
\title{mutate_cond}
\usage{
mutate_cond(.data, condition, ..., envir = parent.frame())
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr)}

\item{condition}{condition for}

\item{...}{<data-masking> Name-value pairs. The name gives the name of the column in the output.}

\item{envir}{environment default( parent.frame())}
}
\description{
Execute dplyr mutate only for rows satisfying condition
}
\examples{
library(dplyr)
df <- data.frame(a = c("X", "Y"), b = 0)
df <- df \%>\% mutate_cond(a == "X", b = 1)
df
}
\author{
ken4rab
}
