% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__CS.R
\name{config_cs}
\alias{config_cs}
\title{Configuration object for the Cuckoo Search Algorithm}
\usage{
config_cs(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL,
  discovery_rate = 0.25,
  step_size = 1
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of host nests.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}

\item{discovery_rate}{probability for the egg laid by a cuckoo to be discovered by the host bird. It
should be between 0 and 1. Default is \code{0.25}.}

\item{step_size}{step size of the Levy flight. Default is \code{1.0}.}
}
\value{
\code{config_cs} returns an object of class \code{CSConfig}.
}
\description{
Create a configuration object for the Cuckoo Search Algorithm (CS). At minimum the number of iterations
(parameter \code{iterations}) and the number of host nests (parameter \code{population_size}) have
to be provided.
}
\references{
\insertRef{Yang2009}{EmiR}
}
