\name{FcnsByCatEstDistParams}
\alias{FcnsByCatEstDistParams}
\alias{Estimating Distribution Parameters}
\concept{Estimation}
\title{
  EnvStats Functions for Estimating Distribution Parameters
}
\description{
  The \pkg{EnvStats} functions listed below are useful for estimating distribution parameters
  and optionally constructing confidence intervals.
}
\details{
  \tabular{ll}{
  \emph{Function Name}                    \tab \emph{Description} \cr
  \code{\link{ebeta}}                     \tab Estimate parameters of a \link{Beta} distribution \cr
  \code{\link{ebinom}}                    \tab Estimate parameter of a \link{Binomial} distribution \cr
  \code{\link{eexp}}                      \tab Estimate parameter of an \link{Exponential} distribution \cr
  \code{\link{eevd}}                      \tab Estimate parameters of an \link[=EVD]{Extreme Value} distribution \cr
  \code{\link{egamma}}                    \tab Estimate shape and scale parameters of a \link[=GammaDist]{Gamma} distribution \cr
  \code{\link{egammaAlt}}                 \tab Estimate mean and CV parameters of a \link[=GammaAlt]{Gamma} distribution \cr
  \code{\link{egevd}}                     \tab Estimate parameters of a \link[=GEVD]{Generalized Extreme Value} distribution \cr
  \code{\link{egeom}}                     \tab Estimate parameter of a \link{Geometric} distribution \cr
  \code{\link{ehyper}}                    \tab Estimate parameter of a \link{Hypergeometric} distribution \cr
  \code{\link{elogis}}                    \tab Estimate parameters of a \link{Logistic} distribution \cr
  \code{\link{elnorm}}                    \tab Estimate parameters of a \link{Lognormal} distribution (log-scale) \cr
  \code{\link{elnormAlt}}                 \tab Estimate parameters of a \link[=LognormalAlt]{Lognormal} distribution (original scale) \cr
  \code{\link{elnorm3}}                   \tab Estimate parameters of a \link[=Lognormal3]{Three-Parameter Lognormal} distribution \cr
  \code{\link{enbinom}}                   \tab Estimate parameter of a \link[=NegBinomial]{Negative Binomial} distribution \cr
  \code{\link{enorm}}                     \tab Estimate parameters of a \link{Normal} distribution \cr
  \code{\link{epareto}}                   \tab Estimate parameters of a \link{Pareto} distribution \cr
  \code{\link{epois}}                     \tab Estimate parameter of a \link{Poisson} distribution \cr
  \code{\link{eunif}}                     \tab Estimate parameters of a \link{Uniform} distribution \cr
  \code{\link{eweibull}}                  \tab Estimate parameters of a \link{Weibull} distribution \cr
  \code{\link{ezmlnorm}}                  \tab Estimate parameters of a \link[=DeltaDist]{Zero-Modified Lognormal (Delta)} \cr
                                          \tab distribution (log-Scale) \cr
  \code{\link{ezmlnormAlt}}               \tab Estimate parameters of a \link[=DeltaDistAlt]{Zero-Modified Lognormal (Delta)} \cr
                                          \tab distribution (original Scale) \cr
  \code{\link{ezmnorm}}                   \tab Estimate parameters of a \link[=ZeroModifiedNormal]{Zero-Modified Normal} distribution \cr
  }
}
\keyword{ package }
