% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{control.icm}
\alias{control.icm}
\title{Control Settings for Stochastic Individual Contact Models}
\usage{
control.icm(type, nsteps, nsims = 1, rec.rand = TRUE, b.rand = TRUE,
  d.rand = TRUE, initialize.FUN = initialize.icm,
  infection.FUN = infection.icm, recovery.FUN = recovery.icm,
  deaths.FUN = deaths.icm, births.FUN = births.icm,
  get_prev.FUN = get_prev.icm, verbose = TRUE, verbose.int = 0,
  skip.check = FALSE, ...)
}
\arguments{
\item{type}{Disease type to be modeled, with the choice of \code{"SI"} for
Susceptible-Infected diseases, \code{"SIR"} for
Susceptible-Infected-Recovered diseases, and \code{"SIS"} for
Susceptible-Infected-Susceptible diseases.}

\item{nsteps}{Number of time steps to solve the model over. This must be a
positive integer.}

\item{nsims}{Number of simulations to run.}

\item{rec.rand}{If \code{TRUE}, use a stochastic recovery model, with the
number of recovered at each time step a function of random draws from
a binomial distribution with the probability equal to \code{rec.rate}.
If \code{FALSE}, then a deterministic rounded count of the expectation
implied by that rate.}

\item{b.rand}{If \code{TRUE}, use a stochastic birth model, with the
number of births at each time step a function of random draws from a
binomial distribution with the probability equal to the governing birth
rates. If \code{FALSE}, then a deterministic rounded count of the
expectation implied by those rates.}

\item{d.rand}{If \code{TRUE}, use a stochastic death model, with the number of
deaths at each time step a function of random draws from a binomial
distribution with the probability equal to the governing death rates.
If \code{FALSE}, then a deterministic rounded count of the expectation
implied by those rates.}

\item{initialize.FUN}{Module to initialize the model at the outset, with the
default function of \code{\link{initialize.icm}}.}

\item{infection.FUN}{Module to simulate disease infection, with the default
function of \code{\link{infection.icm}}.}

\item{recovery.FUN}{Module to simulate disease recovery, with the default
function of \code{\link{recovery.icm}}.}

\item{deaths.FUN}{Module to simulate deaths or exits, with the default
function of \code{\link{deaths.icm}}.}

\item{births.FUN}{Module to simulate births or entries, with the default
function of \code{\link{births.icm}}.}

\item{get_prev.FUN}{Module to calculate disease prevalence at each time step,
with the default function of \code{\link{get_prev.icm}}.}

\item{verbose}{If \code{TRUE}, print model progress to the console.}

\item{verbose.int}{Time step interval for printing progress to console, where
0 (the default) prints completion status of entire simulation and
positive integer \code{x} prints progress after each \code{x} time
steps.}

\item{skip.check}{If \code{TRUE}, skips the default error checking for the
structure and consistency of the parameter values, initial conditions,
and control settings before running integrated epidemic models. Setting
this to \code{FALSE} is recommended when running models with new modules
specified.}

\item{...}{Additional control settings passed to model.}
}
\description{
Sets the controls for stochastic individual contact models
             simulated with \code{\link{icm}}.
}
\details{
\code{control.icm} sets the required control settings for any stochastic
individual contact model solved with the \code{\link{icm}} function. Controls
are required for both integrated model types and when passing original process
modules. For an overview of control settings for integrated ICM class models,
consult the \href{http://statnet.github.io/tut/BasicICMs.html}{Basic ICMs}
tutorial. For all integrated models, the \code{type} argument is a necessary
parameter and it has no default.
}
\section{New Modules}{

Integrated ICM models use a set of module functions that specify
how the individual agents in the population are subjected to infection, recovery,
demographics, and other processes. Core modules are those listed in the
\code{.FUN} arguments. For each module, there is a default function used in
the simulation. The default infection module, for example, is contained in
the \code{\link{infection.icm}} function.

For original models, one may substitute replacement module functions for any of
the default functions. New modules may be added to the workflow at each time
step by passing a module function via the \code{...} argument.
}
\seealso{
Use \code{\link{param.icm}} to specify model parameters and
         \code{\link{init.icm}} to specify the initial conditions. Run the
         parameterized model with \code{\link{icm}}.
}
\keyword{parameterization}

