% Generated by roxygen2 (4.0.1): do not edit by hand
\name{LTR}
\alias{LTR}
\title{Latent Time Residual}
\usage{
LTR(E, I, EnI, ti, te, para, tmax, wt)
}
\arguments{
\item{E}{a vector contains the indices of infected cases excludingt the first case. Note that subjects are indexed from 0 (not 1).}

\item{I}{a vector contains the indices of infectious cases (being infectious or once infectious).}

\item{EnI}{a vector contains the indices of  infected cases which have not yet been infectious (being infectious or once infectious).}

\item{ti}{a vector contains the times of becoming infectious of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10). For testing waiting time in class I, {\code{ti}} should be set to be the time of recovery  {\code{tr}}}

\item{te}{a vector contains the infection times of all subjects recorded in the order of indexing (entry for an non-recovered should be specified to an arbitrary extreme value such as 9e+10). . For testing waiting time in class I, {\code{te}} should be set to be the time of recovery  {\code{ti}}}

\item{para}{either a one-element numeric vector or two-parameter vector contains the parameter arguments of the waiting time distribution to be specified by the user (see argument {\code{wt}}.}

\item{tmax}{the maximum duration of the observational period}

\item{wt}{the cumulative distribution function of the waiting time distribution specified by the user; note that the number of parameter arguments has to match with the length of {\code{para}}.}
}
\value{
a vector contains the set of  imputed residual for infected in the order of indexing.
}
\description{
Latent Time Residual.
}
\details{
The residual test specifically designed to test the goodness-of-fit of the latent period (i.e., waiting time in class E) and the infectious period (i.e., waiting time in class I).
}
\examples{
data(epi)

set.seed(1)

E <- epi$k[which(epi$te!=9e+100 & epi$te!=min(epi$te))]
I <- epi$k[which(epi$ti!=9e+100)]
EnI <- E[!(E\%in\%I)]
ti <- epi$ti
te <- epi$te
tmax <- 60
shape <- 10 #shape parameter for a Gamma waiting time in class E
rate <- 2 # rate parameter for a Gamma waiting time in class E

para_gamma <- c(shape, rate)
para_exp <- shape/rate # an Exponential distribution to match the mean of the Gamma

par(mfrow=c(1,2),mar=c(4,4,4,4))
hist(LTR(E, I, EnI, ti, te, para_gamma, tmax, pgamma), main="Correct Model", xlab="LTR")
hist(LTR(E, I, EnI, ti, te, para_exp, tmax, pexp), main="Wrong Model", xlab="LTR")
}
\author{
Max S.Y. Lau <maxlauhk54@gmail.com>
}
\references{
Lau, Max SY, George Streftaris, Glenn Marion, Gavin J. Gibson. "New model diagnostics for spatio-temporal systems in epidemiology and ecology." Journal of The Royal Society Interface 11.93 (2014): 20131093.
}

