% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{filterAtlasExport}
\alias{filterAtlasExport}
\title{Filter clean Atlas export}
\usage{
filterAtlasExport(x, input, stratified)
}
\arguments{
\item{x}{dataframe, clean Atlas export (see \code{\link{cleanAtlasExport}})}

\item{input}{list of parameters as defined in the Signal Detection Application (see \code{\link{runEpiSDApp}})

(i.e.  \code{list(disease, country, indicator, stratification, unit, daterange, algo, testingperiod)})}

\item{stratified}{a logical value indicating whether the report
should be stratified by \code{Population} variable or not (default \code{FALSE})}
}
\value{
dataframe filtered on the selected parameters (input list)
}
\description{
Filter clean Atlas export according to input parameters
}
\examples{
#-- Setting the parameters to run the report for
input <- list(
disease = "Salmonellosis",
country = "EU-EEA - complete series",
indicator = "Reported cases",
stratification = "Confirmed cases",
unit = "Month",
daterange = c("2010-01-01", "2016-12-31"),
algo = "FarringtonFlexible",
testingperiod = 5
)

#-- Example dataset
dataset <- EpiSignalDetection::SignalData

#-- Filtering on declared input parameters
dataset <- filterAtlasExport(dataset, input, stratified = FALSE)

}
\seealso{
\code{\link{cleanAtlasExport}} \code{\link{aggAtlasExport}}
}
