% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{Export R dataframe as an `EViews` workfile}
\usage{
export(source_description="",wf="",start_date = "",frequency = "",save_path = "")
}
\arguments{
\item{source_description}{Description of the file from which the data is to be imported. The specification of the description is usually just the path and file name of the file.}

\item{wf}{Object or a character string representing the name of a workfile to be created}

\item{start_date}{Object or a character string representing the \code{start date}. It should be left blank for undated (when the \code{frequency} is \code{u}).}

\item{frequency}{Object or a character string representing the frequency of a workfile page to be created. Only letters accepted by EViews are allowed. For example \code{u} for undated, \code{a} for annual, \code{m} for monthly and so on.}

\item{save_path}{Specify where to save the `EViews` workfile.}
}
\value{
An EViews workfile.
}
\description{
Use this function to export R dataframe as an `EViews` workfile
}
\examples{
library(EviewsR)
\dontrun{
x=runif(100); y=runif(100); data=data.frame(x,y)

export(wf="eviewr_export",source_description=data,start_date = '1990',frequency = "m")
}
}
\seealso{
eng_eviews, exec_commands, eviews_graph, eviews_import, create_object, eviews_pagesave, rwalk, eviews_wfcreate, eviews_wfsave, import_table, import
}
\keyword{documentation}
