% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbline.R
\name{nbline}
\alias{nbline}
\title{Number & Brightness (Single Image)}
\usage{
nbline(img, sigma0 = 0, offset = 0, S = 1, w = 0)
}
\arguments{
\item{img}{The image to analyze.}

\item{sigma0}{Variance of the optical system readout noise}

\item{offset}{Constant number that depends on the optical system configuration. Signal values smaller that the offset should be considered zero.}

\item{S}{Proportionality factor S. Indicates the ratio between the amount inicident photons in the detector and those converted to an electronic signal.}

\item{w}{Time window at which the running average is calculated}
}
\value{
A list containing two vectors, the Brightness and the Number of the image.
}
\description{
Performs the Number and Brightness Analysis (N&B) on an image
}
\details{
The Number and Brightness (N&B) method is a time-independent technique that provides an estimate of molecular concentration and aggregation state (or stoichiometry), based on the statistical moments of the fluorescence intensity fluctuations. In other words, this tool allows to distinguish between two or more homo-oligomeric states of a molecule present in a given region in the sample (Brightness) while also providing a direct indicator of the molecules relative abundance (Number).
The intensity of the fluorescence signal is mostly due to the mere presence of fluorophores in the media, affected by the fluorophore quantum yield, the sensitivity of the detector and the photophysical characteristics of the optical instrumentation.
The average particle number and brightness are calculated directly from the mean value <k> and variance (sigma^2) of the fluorescence intensity data (image) for a given pixel as follows: 
N = (<k>^2)/(sigma^2)
and
B = (sigma^2)/<k>
}
\examples{

\donttest{
### Load the FCSlib package

library(FCSlib)

# As an example, we will use a data set that corresponds
# to a population of Venus dimers and hexamers diffusing in HEK-293 cells.
# Use the readFileTiff() function to extract the information from the '.tiff' files.

nbv2 <- nbline(V2)
pixelSize = 0.05
r<- (1:dim(V2)[1])*pixelSize
}
}
\seealso{
\code{\link{var}, \link{mean}}
}
\author{
Raúl Pinto Cámara.
}
