% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{model.matrix.femlm}
\alias{model.matrix.femlm}
\title{Design matrix of a femlm model}
\usage{
\method{model.matrix}{femlm}(object, data, ...)
}
\arguments{
\item{object}{An object of class \code{femlm}. Typically the result of a \code{\link[FENmlm]{femlm}} estimation.}

\item{data}{If missing (default) then the original data is obtained by evaluating the \code{call}. Otherwise, it should be a \code{data.frame}.}

\item{...}{Not currently used.}
}
\value{
It returns a design matrix.
}
\description{
This function creates a design matrix of the linear part of a \code{\link[FENmlm]{femlm}} estimation. Note that it is only the linear part and the cluster variables (which can be considered as factors) are excluded from the matrix.
}
\examples{

# simple estimation on iris data, clustering by "Species"
res = femlm(Sepal.Length ~ Sepal.Width*Petal.Length +
            Petal.Width | Species, iris)

head(model.matrix(res))



}
\seealso{
\code{\link[FENmlm]{femlm}}, \code{\link[FENmlm]{formula.femlm}}, \code{\link[FENmlm]{update.femlm}}, \code{\link[FENmlm]{summary.femlm}}, \code{\link[FENmlm]{vcov.femlm}}.
}
\author{
Laurent Berge
}
