% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{print.femlm}
\alias{print.femlm}
\title{A print facility for \code{femlm} objects. It can compute different types of standard errors.}
\usage{
\method{print}{femlm}(x, n, ...)
}
\arguments{
\item{x}{A femlm object. Obtained using \code{\link[FENmlm]{femlm}}.}

\item{n}{Integer, number of coefficients to display. By default, all estimated coefficients are displayed.}

\item{...}{Other arguments to be passed to \code{\link[FENmlm]{vcov.femlm}}.}
}
\description{
This function is very similar to usual \code{summary} functions as it provides the table of coefficients along with other information on the fit of the estimation.
}
\examples{

# Load trade data
data(trade)

# We estimate the effect of distance on trade => we account for 3 cluster effects
est_pois = femlm(Euros ~ log(dist_km)|Origin+Destination+Product, trade)

# displaying the results
print(est_pois)

# with other type of standard error:
print(est_pois, se = "c")


}
\seealso{
See also the main estimation functions \code{\link[FENmlm]{femlm}}. Use \code{\link[FENmlm]{summary.femlm}} to see the results with the appropriate standard-errors, \code{\link[FENmlm]{getFE}} to extract the cluster coefficients, and the functions \code{\link[FENmlm]{res2table}} and \code{\link[FENmlm]{res2tex}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
