% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{coef.femlm}
\alias{coef.femlm}
\alias{coefficients.femlm}
\title{Extracts the coefficients from a femlm fit}
\usage{
\method{coef}{femlm}(object, ...)

\method{coefficients}{femlm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{femlm}. Typically the result of a \code{\link[FENmlm]{femlm}} estimation.}

\item{...}{Not currently used.}
}
\value{
This function returns a named numeric vector.
}
\description{
This function extracts the coefficients obtained from a model estimated with \code{\link[FENmlm]{femlm}}.
}
\details{
The coefficients are the ones that have been found to maximize the log-likelihood of the specified model. More information can be found on \code{\link[FENmlm]{femlm}} help page.

Note that if the model has been estimated with clusters, to obtain the cluster coefficients, you need to use the function \code{\link[FENmlm]{getFE}}.
}
\examples{

# simple estimation on iris data, clustering by "Species"
res = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
            Petal.Width | Species, iris)

# the coefficients of the variables:
coef(res)

# the cluster coefficients:
getFE(res)


}
\seealso{
\code{\link[FENmlm]{femlm}}, \code{\link[FENmlm]{summary.femlm}}, \code{\link[FENmlm]{confint.femlm}}, \code{\link[FENmlm]{vcov.femlm}}, \code{\link[FENmlm]{res2table}}, \code{\link[FENmlm]{res2tex}}, \code{\link[FENmlm]{getFE}}.
}
\author{
Laurent Berge
}
