% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FLAME_bit.R
\name{FLAME_bit}
\alias{FLAME_bit}
\title{Bit Vectors Implementation}
\usage{
FLAME_bit(data, holdout, tradeoff = 0.1, compute_var = FALSE,
  PE_function = NULL, model = NULL, ridge_reg = NULL,
  lasso_reg = NULL, tree_depth = NULL)
}
\arguments{
\item{data}{input data}

\item{holdout}{holdout training data}

\item{tradeoff}{tradeoff parameter to compute Match Quality (optional, default =
0.1)}

\item{compute_var}{indicator variable of computing variance (optional, default = FALSE)}

\item{PE_function}{user defined function to compute predictive error
(optional)}

\item{model}{user defined model - Linear, Ridge, Lasso, or DecisionTree
(optional)}

\item{ridge_reg}{L2 regularization parameter if model = Ridge (optional)}

\item{lasso_reg}{L1 regularization parameter if model = Lasso (optional)}

\item{tree_depth}{maximum depth of decision tree if model = DecisionTree
(optional)}
}
\value{
(1) list of covariates FLAME performs matching at each iteration, (2)
Sizes, conditional average treatment effects (CATEs), and variance (if compute_var = TRUE)
of matches at each iteration, (3) match quality at each iteration, and (4) the original
data with additional column *matched*, indicating the number of covariates each unit is
matched on. If a unit is never matched, then *matched* will be 0.
}
\description{
\code{FLAME_bit} applies FLAME matching algorithm based on bit vectors.
The required arguments include (1) data and (2) holdout.
The rest of the arguments are optional.
}
\examples{
data(toy_data)
FLAME_bit(data = toy_data, holdout = toy_data)
}
