% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Similarity.R
\name{compute.sim}
\alias{compute.sim}
\title{Similarity}
\usage{
compute.sim(Y, X)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}
}
\description{
Compute the percentage of similarity of two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the value of similarity of two v univariate signals.
A higher similarity (\eqn{Similarity \in [0, 1]}) highlights a more accurate method for completing missing values.
Y and X must have the same length, otherwise an error will be displayed.
Input vectors do not contains NA, if not it a warning will be diplayed.
}
\examples{
data(dataFSMUMI)
X <- dataFSMUMI[, 1] ; Y <- dataFSMUMI[, 2]
compute.sim(Y,X)

# By definition, if true values is a constant vector
# and one or more imputed values are equal to the true values,
# similarity = 1.
X <- rep(5, 100)
Y <- X
compute.sim(Y,X)
}
\author{
Thi-Thu-Hong Phan, Andre Bigand, Emilie Poisson-Caillault
}
