% dudi.tex, antigua afg.tex
\name{FactoClass.tex}

\alias{FactoClass.tex}

\alias{print.FactoClass.tex}

\alias{latexDF}

\alias{roundDF}

\title{Table of Coordinates, Aids of Interpretation of the Principal
       Axes and Cluster Analysis in  LaTeX format.}

\description{ The coordinates, aids of interpretation and results of
              cluster analysis of an object of class \code{FactoClass} are written
              in tables for edition in  LaTeX format and
              written in a file.
              }

\usage{FactoClass.tex(FC,job="",append=TRUE, dir = getwd(), p.clust
= FALSE )

print.FactoClass.tex(x, ...)

latexDF(obj, job="latex" ,tit="" ,lab="" ,append=TRUE ,dec=1,
                     dir = getwd() , to.print = TRUE )
roundDF(tabla,dec=1)

    }

\arguments{
  \item{FC      }{object of class \link{FactoClass}. }
  \item{job     }{A name to identify the exit.}
  \item{append  }{if is \code{'TRUE'} the exit in  LaTeX format is added to the file.}
  \item{dir     }{name of the directory in which the file is kept.}
  \item{p.clust }{the value of this parameter is 'TRUE' or 'FALSE' to print or not the cluster of each element. }
  \item{tabla   }{object of class 'data frame'.}
  \item{dec     }{number of decimal.}
  \item{x       }{object of class FactoClass.tex.}
  \item{obj     }{object of class data.frame.}
  \item{tit     }{title of the table in LaTeX format.}
  \item{lab     }{label of the table in LaTeX format.}
  \item{to.print}{if it is  \code{'TRUE'} the table is also printed in the console.}
  \item{...     }{}
}

 \details{ This function helps with the construction of tables in
            \emph{LaTeX} format.
           Besides, it allows a easy reading of the generated results
           by \link{FactoClass}. The function latexDF is an entrance
           to \code{xtable} and turns an object of class data.frame a table in LaTeX format.
        }

\value{
object of class \code{FactoClass.tex} with the following characteristics:

\item{tvalp}{eigenvalues * 1000.}
\item{c1}{eigenvectors.}
\item{co}{coordinates of the columns.}
\item{col.abs}{contribution of each column to the inertia of the axis (percentage).}
\item{col.rel}{quality of representation of each column (percentage).}
\item{col.cum}{quality of representation of each column accumulated in the subspace (percentage).}
\item{li}{coordinates of the rows.}
\item{row.abs}{contribution of each rows to the inertia of the axis (percentage).}
\item{row.rel}{quality of representation of each rows (percentage).}
\item{row.cum}{quality of representation of each rows accumulated in the subspace (percentage).}
\item{indices}{table of indices of level generated by the Ward cluster analysis.}
\item{cor.clus}{coordinates of the center of gravity of each cluster.}
\item{clus.summ}{summary of the cluster.}
\item{carac.cate}{cluster characterization by qualitative variables.}
\item{carac.cont}{cluster characterization by quantitative variables.}
\item{cluster   }{vector indicating the cluster of each element.}
}

\author{
 Pedro Cesar del Campo \email{pcdelcampon@unal.edu.co}, Campo Elias Pardo \email{cepardot@unal.edu.co}
       }

\examples{

data(BreedsDogs)

BD.act <- BreedsDogs[-7]  # active variables
BD.ilu <- BreedsDogs[7]   # illustrative variables

# MCA

FaCl <- FactoClass( BD.act, dudi.acm,
                    scanFC = FALSE, dfilu = BD.ilu, nfcl = 10, k.clust = 4 )

FactoClass.tex(FaCl,job="BreedsDogs1", append=TRUE)
FactoClass.tex(FaCl,job="BreedsDogs", append=TRUE , p.clust = TRUE)

}

\keyword{multivariate}
