% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Age.R
\name{Age}
\alias{Age}
\title{Age of ego or kin at given calendar date}
\usage{
Age(idref, refT)
}
\arguments{
\item{idref}{vector of IDs of reference population, usually idego}

\item{refT}{Calendar date (decimal date) provided or computed}
}
\value{
\item{Age}{Age of kin (or ego). If ego is not yet born or dead at the reference date, the missing data symbol NA is returned.}
}
\description{
Ages are computed from calendar dates.
}
\examples{

# Load data
data(dLH,package="Families")

# Age of ego on January 1, 2100. Ego is individual with ID equal to 1 in dLH
idego <- 1 
age <- Age(idref=idego,refT=2100)

# Age of ego at death of mother
idego <- dLH$ID[dLH$gen==2]
age <- Age(idref=idego,refT=Dd(IDmother(idego)))

# Age of siblings at ego's 20th birthday
idego <- dLH$ID[dLH$gen==2]
# Get IDs of siblings and convert the list object into a dataframe
idsib <- IDsib(idego)
names(idsib$id) <- idego
dfsib <- Kin_long(idsib$id)
colnames(dfsib) <- c("idego","idkin")
# Get ages of siblings at 20th birthday of egos
dfsib$age <- Age(idref=dfsib$idkin,refT=Db(dfsib$idego)+20)

}
